--PxMEshExport.ms is for PhysX static mesh I/O.
--Author : Hypark Piao
--Contact : hpiao@nvidia.com
--Copyright (C) 2008-2009 nVIDIA Corp.
--For conditions of distribution and use, see copyright notice in http://www.nvidia.com/PhysX.

--purpose: Export selected static mesh node in 3dMax scene into a *.pxmesh file.
fn ExportMesh =
(
	-- Export only geometry
	fn GetGeometry o = ( Superclassof o == Geometryclass and classof o != TargetObject )
	obj = pickobject filter:GetGeometry
	
	if isValidNode obj then
	(
		tmesh = snapshotAsMesh obj 
		out_name = GetSaveFileName \
		caption:nvpxText.meshExportCaption \ 
		types:"nVIDIA PhysX Mesh(*.pxmesh)"
		
		if out_name != undefined then
		(
			out_file = createfile out_name
			num_verts = tmesh.numverts 
			num_faces = tmesh.numfaces
			
			-- Export number of 1.vertices  2.faces.
			format "% %\n" num_verts num_faces to:out_file
			format "\n" to:out_file
			
			-- Export all verts.
			for v = 1 to num_verts do
			(
				local vertex = getVert tmesh v
				format "% % %\n" vertex.x vertex.y vertex.z to:out_file
			)
			
			format "\n" to:out_file
			
			-- Export all faces.
			for f = 1 to num_faces do
			(
				local face = getFace tmesh f
				
				face_x = face.x as integer
				face_y = face.y as integer
				face_z = face.z as integer
				
				format "% % %\n" face_x face_y face_z to:out_file
			)
			
			close out_file
			edit out_name
		)
	)
)

--purpose: A string which holds the ragdoll helper mesh.
strRagdollHelperMesh = stringstream  "96 152
42.8245 36.1444 1.5
45.8245 39.1444 1.5
-46.0751 39.1444 1.5
-43.0751 36.1444 1.5
45.8245 39.1444 -1.5
-46.0751 39.1444 -1.5
42.8245 36.1444 -1.5
-43.0751 36.1444 -1.5
-46.0751 -37.6272 1.5
-43.0751 -34.6272 1.5
-46.0751 -37.6272 -1.5
-43.0751 -34.6272 -1.5
45.8245 -37.6272 1.5
42.8245 -34.6272 1.5
45.8245 -37.6272 -1.5
42.8245 -34.6272 -1.5
-11.8059 -14.7635 -1.5506
-10.4625 -13.6842 -8.7286
-5.9112 -15.4625 -8.1442
-7.2546 -16.5418 -0.966201
-6.4951 -0.121315 1.6449
-1.9438 -1.89962 2.2293
-0.6004 -0.820415 -4.9487
-5.1518 0.957985 -5.5331
-17.6462 -31.1279 -5.8634
-16.5715 -30.2645 -11.6058
-12.0202 -32.0428 -11.0214
-13.0949 -32.9063 -5.279
-11.6716 -14.6555 -2.2684
-7.1202 -16.4339 -1.684
-6.0455 -15.5704 -7.4264
-10.5969 -13.7921 -8.0108
6.2927 -16.5025 1.575
7.6361 -15.4232 -5.6029
12.1521 -13.7991 -4.5135
10.8087 -14.8784 2.6644
0.7808 -1.95152 2.7314
5.2968 -0.327415 3.8208
6.6402 0.751884 -3.3572
2.1242 -0.872215 -4.4465
12.6279 -32.7645 -0.4437
13.7026 -31.9011 -6.186
18.2186 -30.277 -5.0966
17.1439 -31.1404 0.6457
6.427 -16.3946 0.857199
10.943 -14.7705 1.9466
12.0177 -13.9071 -3.7957
7.5017 -15.5312 -4.8851
-5.3152 1.22849 1.3095
-4.2405 2.09188 -4.4328
5.4372 1.91999 -2.6475
4.3625 1.05659 3.0948
-5.5074 21.1614 4.2707
4.1703 20.9895 6.056
5.245 21.8529 0.313697
-4.4327 22.0248 -1.4717
-4.4647 24.1216 7.9475
-2.6736 25.5606 -1.623
3.7782 25.446 -0.432803
1.9871 24.007 9.1378
-4.5398 31.9098 9.1045
1.912 31.7952 10.2948
3.7031 33.2342 0.724197
-2.7487 33.3488 -0.466003
16.2162 18.9266 7.4941
17.1117 19.6462 2.7088
17.0836 22.5667 3.1427
16.188 21.8472 7.928
6.6978 19.0957 5.7382
6.6697 22.0163 6.172
7.5652 22.7358 1.3868
7.5934 19.8152 0.952897
27.9185 18.7923 9.1579
28.635 19.3679 5.3297
28.6068 22.2885 5.7635
27.8904 21.7129 9.5918
16.3057 18.9986 7.0156
16.2776 21.9192 7.4494
16.994 22.4948 3.6212
17.0222 19.5742 3.1874
-17.5656 22.4468 1.7011
-16.67 23.1663 -3.0841
-16.6418 20.2457 -3.518
-17.5374 19.5262 1.2673
-7.8469 22.2741 3.494
-7.8187 19.3536 3.0602
-6.9231 20.0731 -1.7251
-6.9513 22.9937 -1.2912
-30.1329 22.7436 -1.1123
-29.4164 23.3192 -4.9405
-29.3883 20.3986 -5.3744
-30.1047 19.823 -1.5462
-17.476 22.5187 1.2226
-17.4479 19.5982 0.788697
-16.7314 20.1738 -3.0395
-16.7596 23.0944 -2.6056
3 4 1
1 2 3
6 3 2
2 5 6
8 6 5
5 7 8
4 8 7
7 1 4
9 10 4
4 3 9
11 9 3
3 6 11
12 11 6
6 8 12
10 12 8
8 4 10
13 14 10
10 9 13
15 13 9
9 11 15
16 15 11
11 12 16
14 16 12
12 10 14
2 1 14
14 13 2
5 2 13
13 15 5
7 5 15
15 16 7
1 7 16
16 14 1
19 20 17
17 18 19
23 24 21
21 22 23
22 21 17
17 20 22
23 22 20
20 19 23
24 23 19
19 18 24
21 24 18
18 17 21
27 28 25
25 26 27
31 32 29
29 30 31
30 29 25
25 28 30
31 30 28
28 27 31
32 31 27
27 26 32
29 32 26
26 25 29
35 36 33
33 34 35
39 40 37
37 38 39
38 37 33
33 36 38
39 38 36
36 35 39
40 39 35
35 34 40
37 40 34
34 33 37
43 44 41
41 42 43
47 48 45
45 46 47
46 45 41
41 44 46
47 46 44
44 43 47
48 47 43
43 42 48
45 48 42
42 41 45
51 52 49
49 50 51
55 56 53
53 54 55
54 53 49
49 52 54
55 54 52
52 51 55
56 55 51
51 50 56
53 56 50
50 49 53
59 60 57
57 58 59
63 64 61
61 62 63
62 61 57
57 60 62
63 62 60
60 59 63
64 63 59
59 58 64
61 64 58
58 57 61
67 68 65
65 66 67
71 72 69
69 70 71
70 69 65
65 68 70
71 70 68
68 67 71
72 71 67
67 66 72
69 72 66
66 65 69
75 76 73
73 74 75
79 80 77
77 78 79
78 77 73
73 76 78
79 78 76
76 75 79
80 79 75
75 74 80
77 80 74
74 73 77
83 84 81
81 82 83
87 88 85
85 86 87
86 85 81
81 84 86
87 86 84
84 83 87
88 87 83
83 82 88
85 88 82
82 81 85
91 92 89
89 90 91
95 96 93
93 94 95
94 93 89
89 92 94
95 94 92
92 91 95
96 95 91
91 90 96
93 96 90
90 89 93"

--purpose: Construct a new mesh node from a given string which contains mesh info.
fn PxImportMesh strMesh = 
(
	vert_array = #()
	face_array = #()

	if strMesh != undefined then
	(
		num_verts = readValue strMesh 
		num_faces = readValue strMesh 
		vert_array.count = num_verts
		face_array.count = num_faces
		
		for v = 1 to num_verts do
		(
			vx = readValue strMesh
			vy = readValue strMesh
			vz = readValue strMesh
			vert_array[v] = [ vx, vy, vz ]
		)

		for f = 1 to num_faces do
		(
			fx = readValue strMesh
			fy = readValue strMesh
			fz = readValue strMesh
			
			face_array[f] = [ fx,fy,fz ]
		)
		meshNode = mesh vertices:vert_array faces:face_array
	)
)

--purpose: Load ragdoll helper mesh into C++ memory
fn PxImportRagdollHelperMesh = 
(
	meshNode = PxImportMesh strRagdollHelperMesh
	nvpx.LoadRagdollHelperMesh meshNode.mesh
	delete meshNode
)